package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.custom.DatosLocalizacionCustomDao;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0467s00ServiceImpl generated by UDA, 21-Feb-2017 12:47:21.
 * 
 * @author UDA
 */

@Service(value = "ab0467s00Service")
public class DatosLocalizacionServiceImpl implements DatosLocalizacionService {

	@Autowired()
	private DatosLocalizacionCustomDao ab0467s00Dao;

	/**
	 * Inserts a single row in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  Ab0467s00
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the datos localizacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosLocalizacion add(DatosLocalizacion ab0467s00) {
		return this.ab0467s00Dao.add(ab0467s00);
	}

	/**
	 * Updates a single row in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  Ab0467s00
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the datos localizacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosLocalizacion update(DatosLocalizacion ab0467s00) {
		return this.ab0467s00Dao.update(ab0467s00);
	}

	/**
	 * Finds a single row in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  Ab0467s00
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the datos localizacion
	 */
	public DatosLocalizacion find(DatosLocalizacion ab0467s00) {
		return (DatosLocalizacion) this.ab0467s00Dao.vfind(ab0467s00);
	}

	/**
	 * Deletes a single row in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DatosLocalizacion ab0467s00) {
		this.ab0467s00Dao.remove(ab0467s00);
	}

	/**
	 * Finds a list of rows in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0467s00>
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<DatosLocalizacion> findAll(DatosLocalizacion ab0467s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<DatosLocalizacion>) this.ab0467s00Dao.vfindAll(ab0467s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0467s00 table using like.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0467s00>
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<DatosLocalizacion> findAllLike(DatosLocalizacion ab0467s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<DatosLocalizacion>) this.ab0467s00Dao
				.findAllLike(ab0467s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0467s00 table.
	 * 
	 *  filterAb0467s00
	 *            Ab0467s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0467s00>
	 *
	 * @param filterAb0467s00 the filter ab 0467 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<DatosLocalizacion> filter(
			DatosLocalizacion filterAb0467s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<DatosLocalizacion> listaAb0467s00 = this.ab0467s00Dao
				.findAllLike(filterAb0467s00, jqGridRequestDto, false);
		Long recordNum = this.ab0467s00Dao
				.findAllLikeCount(filterAb0467s00 != null ? filterAb0467s00
						: new DatosLocalizacion(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<DatosLocalizacion>> reorderSelection = this.ab0467s00Dao
					.reorderSelection(filterAb0467s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<DatosLocalizacion>(jqGridRequestDto,
					recordNum, listaAb0467s00, reorderSelection);
		}
		return new JQGridResponseDto<DatosLocalizacion>(jqGridRequestDto,
				recordNum, listaAb0467s00);
	}

	/**
	 * Searches rows in the Ab0467s00 table.
	 * 
	 *  filterAb0467s00
	 *            Ab0467s00
	 *  searchAb0467s00
	 *            Ab0467s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0467s00>>
	 *
	 * @param filterAb0467s00 the filter ab 0467 s 00
	 * @param searchAb0467s00 the search ab 0467 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<DatosLocalizacion>> search(
			DatosLocalizacion filterAb0467s00,
			DatosLocalizacion searchAb0467s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0467s00Dao.search(filterAb0467s00, searchAb0467s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0467s00 table.
	 * 
	 *  filterAb0467s00
	 *            Ab0467s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0467s00 the filter ab 0467 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(DatosLocalizacion filterAb0467s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0467s00Dao.reorderSelection(filterAb0467s00,
				jqGridRequestDto, startsWith);
	}

}
